/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.action;

import de.willuhn.jameica.attachment.Attachment;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.internal.action.Program;
import de.willuhn.jameica.services.AttachmentService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.io.File;
import java.io.IOException;

public class AttachmentOpen
implements Action {
    private I18N i18n = Application.getI18n();
    private AttachmentService service = (AttachmentService)Application.getBootLoader().getBootable(AttachmentService.class);

    @Override
    public void handleAction(Object context) throws ApplicationException {
        if (!(context instanceof Attachment)) {
            throw new ApplicationException(this.i18n.tr("Bitte w\u00e4hlen Sie die zu \u00f6ffnende Datei."));
        }
        Attachment a = (Attachment)context;
        try {
            String filename = a.getFilename();
            int dot = filename.lastIndexOf(46);
            String name = dot > 0 ? filename.substring(0, dot) : null;
            String ext = dot > 0 ? filename.substring(dot) : null;
            File temp = File.createTempFile(name != null ? name : a.getStorageId(), ext);
            temp.deleteOnExit();
            this.service.save(a, temp);
            new Program().handleAction(temp);
        }
        catch (IOException e) {
            Logger.error((String)"unable to open file", (Throwable)e);
            throw new ApplicationException(this.i18n.tr("\u00d6ffnen der Datei fehlgeschlagen"));
        }
    }
}

